% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/purityA-constructor.R
\name{assessPuritySingle}
\alias{assessPuritySingle}
\title{Assess the purity of a single LC-MS/MS or DI-MS/MS file}
\usage{
assessPuritySingle(
  filepth,
  fileid = NA,
  mostIntense = FALSE,
  nearest = TRUE,
  offsets = NA,
  cores = 1,
  plotP = FALSE,
  plotdir = NULL,
  interpol = "linear",
  iwNorm = FALSE,
  iwNormFun = NULL,
  ilim = 0,
  mzRback = "pwiz",
  isotopes = TRUE,
  im = NULL,
  ppmInterp = 7
)
}
\arguments{
\item{filepth}{character; mzML file path for MS/MS spectra}

\item{fileid}{numeric; adds a fileid column (primarily for internal use for msPurity)}

\item{mostIntense}{boolean; True if the most intense peak is used for calculation. False if the centered peak is used}

\item{nearest}{boolean; True if the peak selected is as the nearest MS1 scan. If False then the preceding scan is used}

\item{offsets}{vector; Overide the isolation offsets found in the mzML filee.g. c(0.5, 0.5)}

\item{cores}{numeric; Number of cores to use}

\item{plotP}{boolean; If TRUE a plot of the purity is to be saved}

\item{plotdir}{vector; If plotP is TRUE plots will be saved to this directory}

\item{interpol}{character; Type of interolation to be performed "linear", "spline" or "none"}

\item{iwNorm}{boolean; If TRUE then the intensity of the isolation window will be normalised based on the iwNormFun function}

\item{iwNormFun}{function; A function to normalise the isolation window intensity. The default function is very generalised and just accounts for edge effects}

\item{ilim}{numeric; All peaks less than this percentage of the target peak will be removed from the purity calculation, default is 5\% (0.05)}

\item{mzRback}{character; Backend to use for mzR parsing}

\item{isotopes}{boolean; TRUE if isotopes are to be removed}

\item{im}{matrix; Isotope matrix, default removes C13 isotopes (single, double and triple bonds)}

\item{ppmInterp}{numeric; Set the ppm tolerance for the precursor ion purity interpolation. i.e. the ppm tolerence between
the precursor ion found in the neighbouring scans.}
}
\value{
a dataframe of the purity score of the ms/ms spectra
}
\description{
Given a filepath to an mzML file the precursor purity for any MS/MS scans
will be outputed into a dataframe
}
\examples{
filepth <- system.file("extdata", "lcms", "mzML", "LCMSMS_1.mzML", package="msPurityData")

puritydf <- assessPuritySingle(filepth)
}
\seealso{
\code{\link{purityA}}
}
