% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/purityD-av-spectra.R
\name{groupPeaks,purityD-method}
\alias{groupPeaks,purityD-method}
\alias{groupPeaks}
\title{Using purityD object, group multiple peaklists by similar mz values
(mzML or .csv)}
\usage{
\S4method{groupPeaks}{purityD}(Object, ppm = 3, sampleOnly = FALSE, clustType = "hc")
}
\arguments{
\item{Object}{object = purityD object}

\item{ppm}{numeric = The ppm tolerance to group peaklists}

\item{sampleOnly}{= if TRUE the sample peaks will only be grouped}

\item{clustType}{= if 'hc' the hierarchical clustering, if 'simple' the mz values will just be grouped using a simple 1D method}
}
\value{
data.frame of peaklists grouped together by mz
}
\description{
Uses a purityD object to group all the peaklists in the 'avPeaks$processing' slot
}
\examples{

datapth <- system.file("extdata", "dims", "mzML", package="msPurityData")
inDF <- Getfiles(datapth, pattern=".mzML", check = FALSE, cStrt = FALSE)
ppDIMS <- purityD(fileList=inDF, cores=1, mzML=TRUE)
ppDIMS <- averageSpectra(ppDIMS)
grpedP <- groupPeaks(ppDIMS)
}
