% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/purityD-av-spectra.R
\name{groupPeaksEx}
\alias{groupPeaksEx}
\title{Group peaklists from a list of dataframes}
\usage{
groupPeaksEx(peak_list, cores = 1, clustType = "hc", ppm = 2)
}
\arguments{
\item{peak_list}{list = A list (named) of dataframes consiting of a least the following columns ['peakID', 'mz']}

\item{cores}{= number of cores used for calculation}

\item{clustType}{= if 'hc' the hierarchical clustering, if 'simple' the mz values will just be grouped using a simple 1D method}

\item{ppm}{numeric = The ppm tolerance to group peaklists}
}
\value{
data.frame of peaklists grouped together by mz
}
\description{
Group a list of dataframes by their m/z values
}
\examples{

datapth <- system.file("extdata", "dims", "mzML", package="msPurityData")
inDF <- Getfiles(datapth, pattern=".mzML", check = FALSE, cStrt = FALSE)
ppDIMS <- purityD(fileList=inDF, cores=1, mzML=TRUE)
ppDIMS <- averageSpectra(ppDIMS)
grpedP <- groupPeaks(ppDIMS)
}
