% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/purityD-subtract.R
\name{subtractMZ}
\alias{subtractMZ}
\title{Subtract MZ values based on ppm tolerance and noise ratio}
\usage{
subtractMZ(mz1, mz2, i1, i2, ppm = 5, s2bthres = 10)
}
\arguments{
\item{mz1}{vector = mz values to start with}

\item{mz2}{vector = mz values to subtract}

\item{i1}{vector = i values for mz1}

\item{i2}{vector = i values for mz2}

\item{ppm}{numeric = ppm tolerance}

\item{s2bthres}{numeric = threshold for the samp2blank (i1/i2)}
}
\value{
a vector of the remaining mz values
}
\description{
This function is intended for blank subtraction of mz values from two peaklists. It takes in 2 vectors of mz values and 2
coresponding vectors of Intensity values.

The second mz values are subtracted from the first set within an MZ tolerance.

However, if the mz match but the intensity is above a defined threshold then they are not subtracted
}
\examples{
mz1 <- c(100.001, 200.002, 300.302)
mz2 <- c(100.004, 200.003, 500.101)
i1 <- c(100, 100, 100)
i2 <- c(100, 10000, 100)

subtractMZ(mz1, mz2, i1, i2, ppm=5, s2bthres =10)
}
