% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_heatmap.R
\name{plot_heatmap}
\alias{plot_heatmap}
\title{plot_heatmap}
\usage{
plot_heatmap(
  mspms_tidy_data,
  value_colname = "peptides_norm",
  scale = "column",
  plot_method = "plotly",
  show_dendrogram = c(TRUE, TRUE)
)
}
\arguments{
\item{mspms_tidy_data}{tidy mspms data (prepared from QFeatures object
by mspms_tidy())}

\item{value_colname}{the name of the column containing values.}

\item{scale}{how would you like the data scaled? default is none,
but can also be "row", "column", or "none"}

\item{plot_method}{what plot method would you like to use, can use
plotly or ggplot2.}

\item{show_dendrogram}{Logical vector of length two, controlling whether 
the row and/or column dendrograms are displayed. If a logical scalar is 
provided, it is repeated to become a logical vector of length two.}
}
\value{
a heatmaply interactive heatmap
}
\description{
This produces a heatmaply interactive heatmap of the QFeatures object with
color bars representing the condition and time for each sample in each row.
}
\details{
Each column has a colored bar representing whether the peptide is a
cleavage product or a full length member of the peptide library.
}
\examples{
plot_heatmap(mspms::mspms_tidy_data)
}
