% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exportJuicebox.R
\name{exportJuicebox}
\alias{exportJuicebox}
\title{Export multiHiCcompare results for visualization in Juicebox}
\usage{
exportJuicebox(
  hicexp,
  logfc_cutoff = 1,
  logcpm_cutoff = 1,
  p.adj_cutoff = 0.01,
  D_cutoff = 1,
  file_name = "juiceboxAnnotations.txt",
  color = "0,0,255"
)
}
\arguments{
\item{hicexp}{A hicexp object which has been compared.}

\item{logfc_cutoff}{The logFC value you wish to filter
by. Defaults to 1.}

\item{logcpm_cutoff}{The logCPM cutoff you wish to
filter by. Defaults to 1.}

\item{p.adj_cutoff}{The adjusted p-value cutoff you wish to filter
by. Defaults to 0.01.}

\item{D_cutoff}{The distance cutoff you wish to filter
by. Interactions with a D < D_cutoff will be filtered.
Defaults to 1.}

\item{file_name}{The file name of the text file to be saved.}

\item{color}{A decimal RGB color code. Should be a character
value in form of "0,0,255". Defaults to color code for
blue. This will determine the color of the annotations
on the Juicebox heatmap.}
}
\value{
A text file containing annotations for input into Juicebox.
}
\description{
Export multiHiCcompare results for visualization in Juicebox
}
\details{
This function is meant to filter the results of
    multiHiCcompare and export the significant 
    differentially interacting regions into a text file which
    can be imported into Juicebox as a 2D annotations file. This
    will allow you to visualize where your DIRs occur on the heatmap
    of the interactions. Please see the included vignette on using
    Juicebox to visualize multiHiCcompare results. This can be accessed
    with browseVignettes("multiHiCcompare").
}
\examples{
data('hicexp_diff')
exportJuicebox(hicexp_diff, file_name = "juiceboxAnnotations.txt") 
}
