% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sqlclauses.R
\name{sql_org}
\alias{sql_org}
\alias{sql_org,}
\alias{where_org,}
\alias{where_diseasedrug,}
\alias{where_conserved,}
\alias{where_cutoff}
\alias{create_cutoff_name}
\alias{cutoff_to_score}
\alias{where_org}
\alias{where_diseasedrug}
\alias{where_conserved}
\alias{where_cutoff}
\alias{create_cutoff_name}
\alias{cutoff_to_score}
\title{Functions defining the WHERE clauses.}
\usage{
sql_org(.table, org)

where_org(.table, org)

where_diseasedrug(.table, disease.drug)

where_conserved(.table, org, predicted.site)

where_cutoff(.table, score_var, score_cutoff)

create_cutoff_name(.table, org, predicted.site)

cutoff_to_score(.table, cutoff_name, predicted.cutoff.type, predicted.cutoff)
}
\value{
The \code{WHERE} portion of a SQL query
}
\description{
Functions defining filtering by organism (org), disease/drug, conserved, and
cutoff. Filtering by mirna and target are defined within their \code{sql_...}
functions.
}
\keyword{disease}
\keyword{diseasedrug}
\keyword{drug}
\keyword{internal}
\keyword{predicted}
\keyword{tables}
\keyword{types}
\keyword{validated}
