% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diffModuleExpAnalysis.R
\name{diffModuleExpression}
\alias{diffModuleExpression}
\title{Differential module expression}
\usage{
diffModuleExpression(
  WGCNAobject,
  geneList,
  design,
  plotTitle = NULL,
  mode = c("PC1", "Zscore"),
  testColumn = 2,
  refColumn = 3,
  test = c("ANOVA", "PERMANOVA"),
  plot = TRUE
)
}
\arguments{
\item{WGCNAobject}{WGCNA object}

\item{geneList}{vector of genes in WGCNAobject}

\item{design}{the sampleTable}

\item{plotTitle}{title for the plot}

\item{mode}{either PC1 or Zscore, default is PC1}

\item{testColumn}{the column of the sampleTable to be resolved}

\item{refColumn}{the column of the sampleTable to be used as biological variation}

\item{test}{statistical test to perform, either "ANOVA" or "PERMANOVA"}

\item{plot}{generate a plot?}
}
\value{
a data.frame with the resulting p-values
}
\description{
Runs (and plots) the differential module expression analysis
}
\examples{
library(ExperimentHub)
eh = ExperimentHub()
eh_query = query(eh, c("multiWGCNAdata"))
astrocyte_se = eh_query[["EH8223"]]
sampleTable = colData(astrocyte_se)
astrocyte_networks = eh_query[["EH8222"]]
diffModuleExpression(astrocyte_networks[["combined"]], 
  topNGenes(astrocyte_networks$combined, "combined_013"), 
  sampleTable,
  test = "ANOVA",
  plotTitle = "combined_013",
  plot = TRUE)

}
