% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/overlaps.R
\name{moduleToModuleHeatmap}
\alias{moduleToModuleHeatmap}
\title{Module to module heatmap}
\usage{
moduleToModuleHeatmap(
  comparisonDf,
  dataset1 = NULL,
  dataset2 = NULL,
  trait1 = NULL,
  trait2 = NULL,
  list1 = NULL,
  list2 = NULL,
  filterByTrait = FALSE,
  alphaLevel = 0.05
)
}
\arguments{
\item{comparisonDf}{the data.frame output of computeOverlapFromWGCNA}

\item{dataset1}{optional; WGCNA object for dataset 1}

\item{dataset2}{optional; WGCNA object for dataset 2}

\item{trait1}{optional; subset to modules correlated to this trait for dataset 1}

\item{trait2}{optional; subset to modules correlated to this trait for dataset 2}

\item{list1}{subset to this list of modules for dataset 1}

\item{list2}{subset to this list of modules for dataset 2}

\item{filterByTrait}{only plot for modules that correlate with some trait?}

\item{alphaLevel}{the alpha level of significance for module-trait correlation, defaults to 0.05}
}
\value{
A ggplot object
}
\description{
Returns a heatmap where color corresponds to FDR-adjusted overlap (hypergeometric test) and the label corresponds to the number of overlapping genes
}
\examples{
library(ExperimentHub)
eh = ExperimentHub()
eh_query = query(eh, c("multiWGCNAdata"))
astrocyte_networks = eh_query[["EH8222"]]
overlapDf = computeOverlapsFromWGCNA(astrocyte_networks$EAE, astrocyte_networks$WT)
moduleToModuleHeatmap(overlapDf)

}
