% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misalignDetect.R
\name{misalignDetect}
\alias{misalignDetect}
\title{Detect misaligned peak groups in xcmsSet object of XCMS}
\usage{
misalignDetect(xcmsLargeWin, xcmsSmallWin, ppm, qThre = 0.05,
  overlapRate = 0, maxRtWin = 50)
}
\arguments{
\item{xcmsLargeWin}{A \code{\link[xcms]{xcmsSet-class}} object with a larger
\code{bw}, usually the maximum expected retension time drift.}

\item{xcmsSmallWin}{A \code{\link[xcms]{xcmsSet-class}} object with a smaller
\code{bw}, usually the resolution of the retension time.}

\item{ppm}{Should be set as same as the one when performing the peak
detection function in \code{xcms}.}

\item{qThre}{The threshould of the p-value after multiple test correction.
The default is 0.05.}

\item{overlapRate}{The threshould of the overlapping rate of sample index.
The default is 0.}

\item{maxRtWin}{The threshould of the maximum retension time range. This is
for filtering out some bad groups. The default is 50 (seconds).}
}
\value{
A matrix with all detected misaligned peak groups. The column names
are the same as \code{group} slot in \code{\link[xcms]{xcmsSet-class}}, but
the first column is the group index.
}
\description{
This function detects the misaligned peak groups with two
\code{\link[xcms]{xcmsSet-class}} object with two different values of
\code{bw} parameter in \code{\link[xcms:group.density]{group}}.
}
\details{
This function includes two major steps to determine a peak group is
misaligned or not. The first step calculates the p-value of each peak group
in xcmsSmallWin, and find the corresponding peak group in xcmsLargeWin. The
second step is to find the exclusive peak groups (the groups with no
overlapping samples) with adjsted p-values smaller than \code{qThre}.
}
\examples{
# obtain data
data('xcmsExamples')
xcmsLargeWin <- xcmsExamples$xcmsLargeWin
xcmsSmallWin <- xcmsExamples$xcmsSmallWin
ppm <- xcmsExamples$ppm

# detect misaligned features
excluGroups <- misalignDetect(xcmsLargeWin, xcmsSmallWin, ppm)
}
