% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ndex_users.R
\name{ndex_find_user_byName}
\alias{ndex_find_user_byName}
\title{Get User By Name}
\usage{
ndex_find_user_byName(ndexcon, name)
}
\arguments{
\item{ndexcon}{object of class NDExConnection link{ndex_connect}}

\item{name}{name of the user}
}
\value{
list of properties describing the user (externalId, emailAddress, website, etc.). Throws error (404) if user isn't found!
}
\description{
Get User By Name
}
\note{
Compatible to NDEx server version 2.0
}
\section{REST query}{

GET: ndex_config$api$user$get$byName
}

\examples{
## Establish a server connection
ndexcon = ndex_connect()
## Find user by name
user = ndex_find_user_byName(ndexcon, 'ndextutorials')
}
