% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ndex_groups.R
\name{ndex_group_delete_membership}
\alias{ndex_group_delete_membership}
\title{Remove a Group Member}
\usage{
ndex_group_delete_membership(ndexcon, groupId, userId)
}
\arguments{
\item{ndexcon}{object of class NDExConnection link{ndex_connect}}

\item{groupId}{character; unique ID (UUID) of the group}

\item{userId}{character; unique ID (UUID) of the user}
}
\value{
Empty string ("") on success, else error
}
\description{
Removes the member from the group
}
\note{
Requires an authorized user! (ndex_connect with credentials)

Compatible to NDEx server version 2.0
}
\section{REST query}{

DELETE: ndex_config$api$user$membership$delete
}

\examples{
## Establish a server connection with credentials 
# ndexcon = ndex_connect('MyAccountName', 'MyPassword')
## Find user and get own id
# user = ndex_find_user_byName(ndexcon, 'MyAccountName')
# userId = user$externalId
## Find own groups and get one group id
# groups = ndex_user_list_groups(ndexcon, userId)
# groupId = groups[1,"externalId"]
## Find an other user of the group and get the id
# users = ndex_group_list_users(ndexcon, groupId)
## Choose one user 
# userId = users[1,"externalId"]
## Remove user from the group
# ndex_group_delete_membership(ndexcon, groupId, userId)
NULL
}
