% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ndex_networks_ndex_properties.r
\name{ndex_network_set_systemProperties}
\alias{ndex_network_set_systemProperties}
\title{Set Network System Properties}
\usage{
ndex_network_set_systemProperties(
  ndexcon,
  networkId,
  readOnly = NULL,
  visibility = NULL,
  showcase = NULL
)
}
\arguments{
\item{ndexcon}{object of class NDExConnection link{ndex_connect}}

\item{networkId}{unique ID of the network}

\item{readOnly}{boolean (optional); Sets the network to only readable. At least one of readOnly, visibility or showcase have to be set!}

\item{visibility}{character (optional) ('PUBLIC'|'PRIVATE'); Sets the network to only readable. At least one of readOnly, visibility or showcase have to be set!}

\item{showcase}{boolean (optional); Authenticated user can use this property to control whether this network will display in his or her home page. Caller will receive an error if the user does not have explicit permission to that network. At least one of readOnly, visibility or showcase have to be set!}
}
\value{
NULL on success; Error else
}
\description{
Network System properties are the properties that describe the network's status in a particular NDEx server but that are not part of the corresponding CX network object.
}
\note{
Requires an authorized user! (ndex_connect with credentials)

Compatible to NDEx server version 1.3 and 2.0

In version 1.3 only the parameter readOnly is supported
}
\section{REST query}{

GET: ndex_config$api$network$systemproperties$set
}

\examples{
## Establish a server connection with credentials 
# ndexcon = ndex_connect('MyAccountName', 'MyPassword')
## Find one of your networks and get its UUID
# networks = ndex_find_networks(ndexcon, accountName='MyAccountName')
# networkId = networks[1,"externalId"]
## Set network system properties
# ndex_network_set_systemProperties(ndexcon, networkId, readOnly=TRUE)
# ndex_network_set_systemProperties(ndexcon, networkId, visibility="PUBLIC")
# ndex_network_set_systemProperties(ndexcon, networkId, showcase=TRUE)
# ndex_network_set_systemProperties(ndexcon, networkId, 
#                                   readOnly=FALSE, visibility="PRIVATE", showcase=FALSE)
NULL
}
