% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ndex_connect.r
\name{print.NDExConnection}
\alias{print.NDExConnection}
\title{Print a NDExConnection object}
\usage{
\method{print}{NDExConnection}(x, ...)
}
\arguments{
\item{x}{NDExConnection; stores options, authentication and api configuration}

\item{...}{further arguments passed to or from other methods.}
}
\value{
Just prints the NDExConnection object
}
\description{
This function creates an NDExConnection which stores options and authentication details. It is a parameter required for most of the other ndexr functions.
If username and password are missing an anonymous connection is created, which already offers most of the retrieval functionality.
}
\examples{
ndexcon = ndex_connect()   ## log in anonymously
print(ndexcon)
ndexcon = ndex_connect(verbose=TRUE)   ## same as above with extended feedback
print(ndexcon)
\dontrun{
## log in with credentials
ndexcon = ndex_connect('user','password')
print(ndexcon)
## running some NDEx server locally
ndexcon = ndex_connect(host='localhost:8765')
print(ndexcon)
## manually change the api and connection configuration
ndexcon = ndex_connect(ndexConf=ndex_config$Version_2.0)
print(ndexcon)
}
}
\seealso{
\code{\link{ndex_connect}} and \code{\link{ndex_config}}
}
\keyword{internal}
