% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/symmetryCapR.R
\name{symmetryCapR}
\alias{symmetryCapR}
\title{symmetryCapR}
\usage{
symmetryCapR(
  dir_stereogene_output = ".",
  CapR_prefix = "",
  protein_file,
  protein_file_input = NULL,
  context = "all",
  range = c(-200, 200)
)
}
\arguments{
\item{dir_stereogene_output}{Directory of Stereogene output for first
protein. Default current directory.}

\item{CapR_prefix}{The prefix common to CapR output files of protein_file, if
applicable. Equivalent to output_prefix from runStereogeneOnCapR. Default ""}

\item{protein_file}{A vector of strings with at least one protein file name
to be averaged for calculation of distance. File names must exclude
extensions such as ".bedGraph". All files in the list should be
experimental/biological replicates. Required.}

\item{protein_file_input}{A protein file name of background input to be
subtracted from protein_file signal. File name must exclude extension. Only
one input file is permitted. Optional.}

\item{context}{The RNA structure context being interrogated. Acceptable
contexts include "all", which sums the distance of all six contexts, or any
of the contexts individually ("bulge", "hairpin", "stem", "exterior",
"multibranch", or "internal"). Default "all"}

\item{range}{A vector of two integers denoting the range upstream and
downstream of the center of protein binding to consider in the comparison.
Ranges that are too small miss the holistic binding context, while large
ranges amplify distal noise in the binding data. Cannot exceed wSize/2 from
write_config. Default c(-200, 200)}
}
\value{
Wasserstein distance between the two halves of the binding context,
with lower values suggesting greater symmetry.
}
\description{
Calculate the symmetry of a binding context.
}
\examples{
## load example StereoGene output
get_outfiles()

## This boring example compares a protein's binding with itself for all
## contexts, therefore the distance is 0
symmetryCapR(CapR_prefix = "chr4and5_3UTR",
                protein_file = "chr4and5_liftOver")

}
