% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/symmetryContext.R
\name{symmetryContext}
\alias{symmetryContext}
\title{symmetryContext}
\usage{
symmetryContext(
  dir_stereogene_output = ".",
  context_file,
  protein_file,
  protein_file_input = NULL,
  range = c(-200, 200)
)
}
\arguments{
\item{dir_stereogene_output}{Directory of Stereogene output for protein.
Default current directory.}

\item{context_file}{Name of the RNA context file input to Stereogene. File
names must exclude extensions such as ".bedGraph". Requred}

\item{protein_file}{A vector of at least one protein file name to be
averaged for calculation of distance. File names must exclude extensions
such as ".bedGraph". All files in the list should be experimental/biological
replicates. Required.}

\item{protein_file_input}{A protein file name of background input to be
subtracted from protein_file signal. File name must exclude extension. Only
one input file is permitted. Optional.}

\item{range}{A vector of two integers denoting the range upstream and
downstream of the center of protein binding to consider in the comparison.
Ranges that are too small miss the holistic binding context, while large
ranges amplify distal noise in the binding data. Cannot exceed wSize/2 from
write_config. Default c(-200, 200)}
}
\value{
Wasserstein distance between the two halves of the binding context,
with lower values suggesting greater symmetry.
}
\description{
Calculate the symmetry of a binding context.
}
\examples{
## load example StereoGene output
get_outfiles()

## This boring example compares a protein's binding with itself for all
## contexts, therefore the distance is 0
symmetryContext(context_file = "chr4and5_3UTR_stem_liftOver",
                       protein_file = "chr4and5_liftOver")

}
