% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_fasta.R
\name{write_fasta}
\alias{write_fasta}
\title{write_fasta}
\usage{
write_fasta(sequences, names, file.out)
}
\arguments{
\item{sequences}{A vector of sequences}

\item{names}{A vector of names corresponding to the sequences}

\item{file.out}{Name of output FASTA file; a string}
}
\value{
writes FASTA file into directory
}
\description{
Writes a FASTA file from a vector of sequences
}
\examples{
sequences<-c(paste0(sample(c("A", "T", "G", "C"), 20, replace = TRUE),
                   collapse = ""),
            paste0(sample(c("A", "T", "G", "C"), 20, replace = TRUE),
                   collapse = ""),
            paste0(sample(c("A", "T", "G", "C"), 20, replace = TRUE),
                   collapse = ""))
write_fasta(sequences,
           c("one", "two", "three"),
           "test.fa")

}
