% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diffregr.R
\name{diffregr_multisplit}
\alias{diffregr_multisplit}
\title{Differential Regression (multi-split version).}
\usage{
diffregr_multisplit(y1, y2, x1, x2, b.splits = 50, frac.split = 1/2,
  screen.meth = "screen_cvtrunc.lasso", gamma.min = 0.05,
  compute.evals = "est2.my.ev3.diffregr",
  method.compquadform = "imhof", acc = 1e-04, epsabs = 1e-10,
  epsrel = 1e-10, show.warn = FALSE, n.perm = NULL,
  mc.flag = FALSE, mc.set.seed = TRUE, mc.preschedule = TRUE,
  mc.cores = getOption("mc.cores", 2L), ...)
}
\arguments{
\item{y1}{Response vector condition 1.}

\item{y2}{Response vector condition 2.}

\item{x1}{Predictor matrix condition 1.}

\item{x2}{Predictor matrix condition 2.}

\item{b.splits}{Number of splits (default=50).}

\item{frac.split}{Fraction train-data (screening) / test-data (cleaning) (default=0.5).}

\item{screen.meth}{Screening method (default='screen_cvtrunc.lasso').}

\item{gamma.min}{Tuning parameter in p-value aggregation of Meinshausen et al (2009) (default=0.05).}

\item{compute.evals}{Method to estimate the weights in the weighted-sum-of-chi2s distribution.
The default and (currently) the only available option 
is the method 'est2.my.ev3.diffregr'.}

\item{method.compquadform}{Algorithm for computing distribution function
of weighted-sum-of-chi2 (default='imhof').}

\item{acc}{See ?davies (default=1e-4).}

\item{epsabs}{See ?imhof (default=1e-10).}

\item{epsrel}{See ?imhof (default=1e-10).}

\item{show.warn}{Show warnings (default=FALSE)?}

\item{n.perm}{Number of permutation for "split-perm" p-value. Default=NULL, which means
that the asymptotic approximation is used.}

\item{mc.flag}{If \code{TRUE} use parallel execution for each b.splits via function 
\code{mclapply} of package \code{parallel}.}

\item{mc.set.seed}{See mclapply. Default=TRUE}

\item{mc.preschedule}{See mclapply. Default=TRUE}

\item{mc.cores}{Number of cores to use in parallel execution. Defaults to
mc.cores option if set, or 2 otherwise.}

\item{...}{Other arguments specific to screen.meth.}
}
\value{
List consisting of
\item{ms.pval}{p-values for all b.splits}
\item{ss.pval}{single-split p-value}
\item{medagg.pval}{median aggregated p-value}
\item{meinshagg.pval}{meinshausen aggregated p-value (meinshausen et al 2009)}
\item{teststat}{test statistics for b.splits}
\item{weights.nulldistr}{estimated weights}
\item{active.last}{active-sets obtained in last screening-step}
\item{beta.last}{constrained mle (regression coefficients) obtained in last cleaning-step}
}
\description{
Differential Regression (multi-split version).
}
\details{
Intercepts in regression models are assumed to be zero (mu1=mu2=0).
You might need to center the input data prior to running
Differential Regression.
}
\examples{
###############################################################
##This example illustrates the use of Differential Regression##
###############################################################

##set seed
set.seed(1)

## Number of predictors and sample size
p <- 100
n <- 80

## Predictor matrices
x1 <- matrix(rnorm(n*p),n,p)
x2 <- matrix(rnorm(n*p),n,p)

## Active-sets and regression coefficients
act1 <- sample(1:p,5)
act2 <- c(act1[1:3],sample(setdiff(1:p,act1),2))
beta1 <- beta2 <- rep(0,p)
beta1[act1] <- 0.5
beta2[act2] <- 0.5

## Response vectors under null-hypothesis
y1 <- x1\%*\%as.matrix(beta1)+rnorm(n,sd=1)
y2 <- x2\%*\%as.matrix(beta1)+rnorm(n,sd=1)

## Diffregr (asymptotic p-values)
fit.null <- diffregr_multisplit(y1,y2,x1,x2,b.splits=5)
fit.null$ms.pval#multi-split p-values
fit.null$medagg.pval#median aggregated p-values

## Response vectors under alternative-hypothesis
y1 <- x1\%*\%as.matrix(beta1)+rnorm(n,sd=1)
y2 <- x2\%*\%as.matrix(beta2)+rnorm(n,sd=1)

## Diffregr (asymptotic p-values)
fit.alt <- diffregr_multisplit(y1,y2,x1,x2,b.splits=5)
fit.alt$ms.pval
fit.alt$medagg.pval

## Diffregr (permutation-based p-values; 100 permutations)
fit.alt.perm <- diffregr_multisplit(y1,y2,x1,x2,b.splits=5,n.perm=100)
fit.alt.perm$ms.pval
fit.alt.perm$medagg.pval


}
\author{
n.stadler
}
