% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pkg-package.R
\docType{package}
\name{netresponse-package}
\alias{netresponse-package}
\alias{netresponse}
\title{NetResponse: Global modeling of transcriptional responses in interaction networks}
\description{
Global modeling of transcriptional responses in interaction networks.
\tabular{ll}{ Package: \tab netresponse\cr Type: \tab Package\cr Version:
\tab See sessionInfo() or DESCRIPTION file\cr Date: \tab 2011-02-03\cr
License: \tab GNU GPL >=2\cr LazyLoad: \tab yes\cr }
}
\examples{
\dontrun{
# Define parameters for toy data
Ns <- 200  # number of samples (conditions)
Nf <- 10   # number of features (nodes)
feature.names <- paste('feat', seq(Nf), sep='')
sample.names  <- paste('sample', seq(Ns), sep='') 
# random seed
set.seed( 123 )
# Random network
netw <- pmax(array(sign(rnorm(Nf^2)), dim = c(Nf, Nf)), 0)
# in pathway analysis nodes correspond to genes
rownames(netw) <- colnames(netw) <- feature.names
# Random responses of the nodes across conditions 
D <- array(rnorm(Ns*Nf), dim = c(Ns,Nf), dimnames = list(sample.names, feature.names))
D[1:100, 4:6]  <- t(sapply(1:(Ns/2),function(x){rnorm(3, mean = 1:3)}))
D[101:Ns, 4:6] <- t(sapply(1:(Ns/2),function(x){rnorm(3, mean = 7:9)}))
# Calculate the model
#model <- detect.responses(D, netw)
## Subnets (each is a list of nodes)
#get.subnets( model )
}
}
\references{
Leo Lahti et al.: Global modeling of transcriptional responses
in interaction networks. Bioinformatics (2010). See citation('netresponse')
for details.
}
\author{
Leo Lahti, Olli-Pekka Huovilainen, Antonio Gusmao and Juuso
Parkkinen. Maintainer: Leo Lahti \email{leo.lahti@iki.fi}
}
\keyword{package}
