% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/response2sample.R
\name{response2sample}
\alias{response2sample}
\title{response2sample}
\usage{
response2sample(
  model,
  subnet.id = NULL,
  component.list = TRUE,
  verbose = FALSE,
  data = NULL
)
}
\arguments{
\item{model}{A NetResponseModel object or list.}

\item{subnet.id}{Subnet id. A natural number which specifies one of the
subnetworks within the 'model' object.}

\item{component.list}{List samples separately for each mixture component
(TRUE). Else list the most strongly associated component for each sample
(FALSE).}

\item{verbose}{Follow progress by intermediate messages.}

\item{data}{Data (features x samples; or a vector for univariate case) to predict response for given data points (currently implemented only for mixture.model output)

Return:}
}
\value{
A list. Each element corresponds to one subnetwork response, and
contains a list of samples that are associated with the response (samples
for which this response has the highest probability P(response | sample)).
}
\description{
List the most strongly associated response of a given subnetwork for each sample.
}
\examples{
# Load example data
data( toydata )         # Load toy data set
D    <- toydata$emat    # Response matrix (for example, gene expression)
model <- toydata$model  # Pre-calculated model

# Find the samples for each response (for a given subnetwork)
response2sample(model, subnet.id = 1)

}
\references{
Leo Lahti et al.: Global modeling of transcriptional responses
in interaction networks. Bioinformatics (2010).  See citation('netresponse')
for citation details.
}
\author{
Leo Lahti \email{leo.lahti@iki.fi}
}
\keyword{utilities}
