% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/global_scores_eigenvalues_plot.R
\name{global_scores_eigenvalues_plot}
\alias{global_scores_eigenvalues_plot}
\title{global_scores_eigenvalues_plot}
\usage{
global_scores_eigenvalues_plot(mcia_results)
}
\arguments{
\item{mcia_results}{MCIA results object returned from `nipals_multiblock`}
}
\value{
Displays the contribution plot using eigenvalues
}
\description{
Function to plot eigenvalues of scores up to num_PCs
}
\details{
Plotting function for eigenvalues of scores up to num_PCs
}
\examples{
data(NCI60)
data_blocks_mae <- simple_mae(data_blocks,row_format="sample",
                             colData=metadata_NCI60)
mcia_results <- nipals_multiblock(data_blocks_mae, num_PCs = 10,
                                 plots = "none", tol=1e-12)
global_scores_eigenvalues_plot(mcia_results)
}
