% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vis_load_ord.R
\name{vis_load_ord}
\alias{vis_load_ord}
\title{Visualize ranked loadings}
\usage{
vis_load_ord(
  mcia_results,
  omic,
  factor = 1,
  n_feat = 15,
  absolute = TRUE,
  descending = TRUE,
  color_pal = scales::viridis_pal,
  color_pal_params = list()
)
}
\arguments{
\item{mcia_results}{object returned from nipals_multiblock() function}

\item{omic}{name of the given omic dataset}

\item{factor}{choose a factor (numeric value from 1 to number of factors
in mcia_results)}

\item{n_feat}{number of features to visualize}

\item{absolute}{whether to rank by absolute value}

\item{descending}{whether to rank in descending or ascending order}

\item{color_pal}{a list of colors or function which returns a list of colors}

\item{color_pal_params}{a list of parameters for the color function}
}
\value{
Plot in features for a factor by rank
}
\description{
Visualize a scree plot of loadings recovered from
nipalsMCIA() output loadings matrix ranked using the
ord_loadings() functions
}
\examples{
data(NCI60)
data_blocks_mae <- simple_mae(data_blocks,row_format="sample",
                              colData=metadata_NCI60)
mcia_results <- nipals_multiblock(data_blocks_mae, num_PCs = 10,
                                  plots = "none", tol = 1e-12)
vis_load_ord(mcia_results, omic="mrna")
}
