% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stats.R
\name{cohens_d}
\alias{cohens_d}
\title{Cohen's D}
\usage{
cohens_d(object, group, id = NULL, time = NULL, assay.type = NULL)
}
\arguments{
\item{object}{a \code{
\link[SummarizedExperiment:SummarizedExperiment-class]{SummarizedExperiment}}
object}

\item{group}{character, name of the group column}

\item{id}{character, name of the subject ID column}

\item{time}{character, name of the time column}

\item{assay.type}{character, assay to be used in case of multiple assays}
}
\value{
A data frame with Cohen's d for each feature.
}
\description{
Computes Cohen's D for each feature. If time and ID are supplied,
change between two time points is computed for each subject,
and Cohen's d is computed from the changes.
}
\examples{
data(toy_notame_set, package = "notame")
d_results <- cohens_d(notame::drop_qcs(toy_notame_set), group = "Group")
d_results_time <- cohens_d(notame::drop_qcs(toy_notame_set),
  group = "Group", time = "Time", id = "Subject_ID"
)

}
