% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multivariate.R
\name{pls_da}
\alias{pls_da}
\alias{mixomics_plsda}
\alias{mixomics_plsda_optimize}
\alias{mixomics_splsda_optimize}
\title{PLS-DA}
\usage{
mixomics_plsda(
  object,
  y,
  ncomp,
  all_features = FALSE,
  covariates = NULL,
  assay.type = NULL,
  ...
)

mixomics_plsda_optimize(
  object,
  y,
  ncomp,
  plot_perf = FALSE,
  folds = 5,
  nrepeat = 50,
  all_features = FALSE,
  covariates = NULL,
  assay.type = NULL,
  ...
)

mixomics_splsda_optimize(
  object,
  y,
  ncomp,
  dist,
  plot_perf = FALSE,
  n_features = c(seq_len(10), seq(20, 300, 10)),
  folds = 5,
  nrepeat = 50,
  all_features = FALSE,
  covariates = NULL,
  assay.type = NULL,
  ...
)
}
\arguments{
\item{object}{a SummarizedExperiment object}

\item{y}{character, column name of the grouping variable to predict}

\item{ncomp}{the number of X components}

\item{all_features}{logical, should all features be included in the model? 
if FALSE, flagged features are left out}

\item{covariates}{character, column names of pheno data to use as covariates 
in the model, in addition to molecular features}

\item{assay.type}{character, assay to be used in case of multiple assays}

\item{...}{any parameters passed to 
\code{\link[mixOmics]{plsda}}}

\item{plot_perf}{plot performance of models in cross-validation}

\item{folds}{the number of folds to use in k-fold cross validation}

\item{nrepeat}{the number of times to repeat the cross validation. Lower 
this for faster testing.}

\item{dist}{the distance metric to use, one of "max.dist", 
"mahalanobis.dist", "centroids.dist".
use \code{\link{mixomics_plsda_optimize}} to find the best distance metric}

\item{n_features}{the number of features to try for each component}
}
\value{
An object of class "mixo_plsda" or for the optimized and sparse 
models, a list with object of class "mixo_plsda" and a performance plot.
}
\description{
A simple wrapper for fitting a PLS-DA model using mixOmics package. 
The object can then be passed to many of the mixOmics 
functions for prediction, performance evaluation etc.
\itemize{
\item{\code{mixomics_plsda} A simple PLS-DA model with set number of 
components and all features}
\item{\code{mixomics_plsda_optimize} Test different numbers of components,
choose the one with minimal balanced error rate}
\item{\code{mixomics_splsda_optimize} Test different numbers 
of components and features, choose the one with minimal balanced error rate}
}
}
\examples{
data(toy_notame_set, package = "notame")
noqc <- notame::drop_qcs(toy_notame_set)
plsda_res <- mixomics_plsda(noqc, y = "Group", ncomp = 2)
# Cross-validation repeated only 5 times for quick run time 
set.seed(38)
plsda_opt <- mixomics_plsda_optimize(noqc, 
  y = "Group", ncomp = 3, nrepeat = 5
)
set.seed(38)
splsda_opt <- mixomics_splsda_optimize(noqc,
  y = "Group", dist = "max.dist", ncomp = 2,
  n_features = c(1:10, 12, 15, 20), nrepeat = 5
)
# Plot PLS-DA scores
mixOmics::plotIndiv(plsda_res, 
  comp = seq_len(2), group = notame::drop_qcs(toy_notame_set)$Group, 
  ind.names = FALSE, title = "PLS-DA scores plot", legend = TRUE, 
  ellipse = TRUE)

# Plot prediction areas
background <- mixOmics::background.predict(plsda_res, 
  comp.predicted = 2, dist = "max.dist")
mixOmics::plotIndiv(plsda_res,
  comp = seq_len(2), group = notame::drop_qcs(toy_notame_set)$Group, 
  ind.names = FALSE, 
  title = "prediction areas", legend = TRUE, background = background)

}
\seealso{
\code{\link[mixOmics]{plsda}}, \code{\link[mixOmics]{perf}},
\code{\link[mixOmics]{splsda}}, \code{\link[mixOmics]{tune.splsda}}
}
