% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scatter.R
\name{plot_pca_loadings}
\alias{plot_pca_loadings}
\title{PCA loadings plot}
\usage{
plot_pca_loadings(
  object,
  pcs = c(1, 2),
  all_features = FALSE,
  center = TRUE,
  scale = "uv",
  n_features = c(10, 10),
  title = "PCA loadings",
  subtitle = NULL,
  text_base_size = 14,
  point_size = 2,
  label_text_size = 4,
  assay.type = NULL,
  ...
)
}
\arguments{
\item{object}{a \code{
\link[SummarizedExperiment:SummarizedExperiment-class]{SummarizedExperiment}}
object}

\item{pcs}{numeric vector of length 2, the principal components to plot}

\item{all_features}{logical, should all features be used? If FALSE (the 
default), flagged features are removed before visualization.}

\item{center}{logical, should the data be centered prior to PCA? (usually 
yes)}

\item{scale}{scaling used, as in \code{\link[pcaMethods]{prep}}. Default is 
"uv" for unit variance}

\item{n_features}{numeric vector of length two, number of top feature to plot
for each principal component}

\item{title, subtitle}{the titles of the plot}

\item{text_base_size}{numeric, base size for text}

\item{point_size}{numeric, size of the points}

\item{label_text_size}{numeric, size of the labels}

\item{assay.type}{character, assay to be used in case of multiple assays}

\item{...}{additional arguments passed to \code{\link[pcaMethods]{prep}}}
}
\value{
A ggplot object.
}
\description{
Computes PCA using one of the methods provided in the Bioconductor package
pcaMethods and plots the loadings of first principal components.
}
\examples{
data(toy_notame_set, package = "notame")
plot_pca_loadings(toy_notame_set, n_features = c(2, 4))

}
\seealso{
\code{\link[pcaMethods]{pca}}
}
