% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qc_visualizations.R
\name{visualize_clusters}
\alias{visualize_clusters}
\title{Visualize clusters of features}
\usage{
visualize_clusters(
  object,
  min_size = 3,
  rt_window = 1/60,
  n_clust_col = "Cluster_size",
  clust_col = "Cluster_features",
  mpa_col = "MPA",
  mz_col = NULL,
  rt_col = NULL
)
}
\arguments{
\item{object}{a \code{
\link[SummarizedExperiment:SummarizedExperiment-class]{SummarizedExperiment}}
object with clustering metadata}

\item{min_size}{the minimum number of features a cluster needs to have to be 
plotted}

\item{rt_window}{numeric, the retention time window to use in linking 
features. NOTE you need to use the same unit as in the retention time column}

\item{n_clust_col}{character, name of the column that contains the features 
included in cluster, separated by semicolon}

\item{clust_col}{character, name of the column that contains the features in 
a cluster}

\item{mpa_col}{character, name of column that contains median peak area of 
features}

\item{mz_col}{character, name of the column in features that contains
mass-to-charge ratios}

\item{rt_col}{character, name of the column in features that contains 
retention times}
}
\value{
A list with clusters containing two plots, a heatmap
}
\description{
Draws multiple visualizations of each cluster, creating a separate file for
each cluster.
}
\details{
Note that the input data has been assigned clusters but has not yet been 
compressed, for example by retaining the feature with the highest median 
peak area.
}
\examples{
\dontshow{.old_wd <- setwd(tempdir())}
data(toy_notame_set, package = "notame")
# The parameters are really weird because example data is imaginary
clustered <- notame::cluster_features(toy_notame_set, rt_window = 1, 
                                      corr_thresh = 0.5, d_thresh = 0.6)

cluster_plots <- visualize_clusters(clustered, rt_window = 1)
\dontshow{setwd(.old_wd)}
}
