% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/batch_correction.R
\name{perform_repeatability}
\alias{perform_repeatability}
\title{Compute repeatability measures}
\usage{
perform_repeatability(object, group, assay.type = NULL)
}
\arguments{
\item{object}{a \code{
\link[SummarizedExperiment:SummarizedExperiment-class]{SummarizedExperiment}}
object}

\item{group}{column name of pheno data giving the group labels}

\item{assay.type}{character, assay to be used in case of multiple assays}
}
\value{
A data frame with one row per feature with the repeatability measure.
}
\description{
Computes repeatability for each feature with the following formula:
\deqn{\frac{\sigma^2_{between}}{\sigma^2_{between} + \sigma^2_{within}}}
The repeatability ranges from 0 to 1. Higher repeatability depicts less
variation between batches.
}
\examples{
data(toy_notame_set)
# Batch correction
replicates <- list(which(toy_notame_set$QC == "QC"))
batch_corrected <- ruvs_qc(toy_notame_set, replicates = replicates)
# Evaluate batch correction
rep_orig <- perform_repeatability(toy_notame_set, group = "Group")
mean(rep_orig$Repeatability, na.rm = TRUE)
rep_corr <- perform_repeatability(batch_corrected, group = "Group")
mean(rep_corr$Repeatability, na.rm = TRUE)

}
