% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R
\docType{class}
\name{MatchedDataFrame-class}
\alias{MatchedDataFrame-class}
\alias{MatchedDataFrame}
\title{MatchedDataFrame objects}
\description{
The \code{MatchedDataFrame} class is a subclass of both
\code{Matched} and \code{DFrame}. Therefore, it contains slots
and methods for both of these classes.
}
\details{
The \code{MatchedDataFrame} class uses a delegate object
during initialization to assign its \code{DFrame} slots.
\code{MatchedDataFrame} behaves as a \code{DataFrame} but also
includes additional \code{Matched} object functionality
(see \code{?Matched}). For more information about
\code{DataFrame} see \code{?S4Vectors::DataFrame}.
}
\section{Slots}{

\describe{
\item{\code{focal}}{A \code{DataFrame} object containing the focal
data to match.}

\item{\code{pool}}{A \code{DataFrame} object containing the pool
from which to select matches.}

\item{\code{delegate}}{A \code{DataFrame} object used to initialize
\code{DataFrame}-specific slots. \code{matchRanges()} assigns
the matched set to the slot.}

\item{\code{matchedData}}{A \code{data.table} with matched data}

\item{\code{matchedIndex}}{An integer vector corresponding
to the indices in the \code{pool} which comprise the
\code{matched} set.}

\item{\code{covar}}{A character vector describing the covariates
used for matching.}

\item{\code{method}}{Character describing replacement method
used for matching.}

\item{\code{replace}}{TRUE/FALSE describing if matching was
done with or without replacement.}

\item{\code{rownames}}{\code{rownames(delegate)}}

\item{\code{nrows}}{\code{nrows(delegate)}}

\item{\code{listData}}{\code{as.list(delegate)}}

\item{\code{elementType}}{\code{elementType(delegate)}}

\item{\code{elementMetadata}}{\code{elementMetadata(delegate)}}

\item{\code{metadata}}{\code{metadata(delegate)}}
}}

\section{Accessor methods for Matched Class}{

Functions that get data from Matched subclasses (\code{x})
such as MatchedDataFrame, MatchedGRanges,
and MatchedGInteractions are listed below:
\itemize{
\item \code{matchedData(x)}: Get matched data from a Matched object
\item \code{covariates(x)}: Get covariates from a Matched object
\item \code{method(x)}: Get matching method used for Matched object
\item \code{withReplacement(x)}: Get replace method
\item \code{indices(x, set)}: Get indices of matched set
}
For more detail check the help pages for these functions.
}

\section{Accessor methods for Matched subclass objects}{

Additional functions that get data from Matched subclasses
(\code{x}) such as MatchedDataFrame, MatchedGRanges,
and MatchedGInteractions include:
\itemize{
\item \code{focal(x)}: Get focal set from a Matched object
\item \code{pool(x)}: Get pool set from a Matched object
\item \code{matched(x)}: Get matched set from a Matched object
\item \code{unmatched(x)}: Get unmatched set from a Matched object
}
For more detail check the help pages for these functions.
}

\examples{
## Constructing MatchedDataFrame with matchRanges
## data.frame
set.seed(123)
x <- makeExampleMatchedDataSet(type = "data.frame")
mx <- matchRanges(
  focal = x[x$feature1, ],
  pool = x[!x$feature1, ],
  covar = ~ feature2 + feature3,
  method = "rejection",
  replace = FALSE
)
class(mx)

## data.table
set.seed(123)
x <- makeExampleMatchedDataSet(type = "data.table")
mx <- matchRanges(
  focal = x[x$feature1],
  pool = x[!x$feature1],
  covar = ~ feature2 + feature3,
  method = "rejection",
  replace = FALSE
)
class(mx)

## DataFrame
set.seed(123)
x <- makeExampleMatchedDataSet(type = "DataFrame")
mx <- matchRanges(
  focal = x[x$feature1, ],
  pool = x[!x$feature1, ],
  covar = ~ feature2 + feature3,
  method = "rejection",
  replace = FALSE
)
class(mx)

## Make MatchedDataFrame example
set.seed(123)
x <- makeExampleMatchedDataSet(type = "DataFrame", matched = TRUE)
## Accessor functions for Matched class
matchedData(x)
covariates(x)
method(x)
withReplacement(x)
head(indices(x, set = 'matched'))

## Accessor functions for Matched subclasses
focal(x)
pool(x)
matched(x)
unmatched(x)

}
\seealso{
\link[S4Vectors:DataFrame-class]{S4Vectors::DataFrame}

\link{matchedData}, \link{covariates}, \link{method},
\link{withReplacement}, \link{indices}

\link{focal}, \link{pool}, \link{matched}, \link{unmatched}
}
