% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01_AllMethods.R, R/MultiDataSet-association.R
\docType{methods}
\name{association}
\alias{association}
\alias{association,MultiDataSet-method}
\alias{association}
\title{# -----------------------------------------------------------------------------
Method to perform an association study between transcriptome and exposom}
\usage{
association(object, formula, expset, omicset, set = "exposures",
  method = "ls", ..., baselevels, sva = "none", vfilter = NULL,
  verbose = FALSE, warnings = TRUE)

\S4method{association}{MultiDataSet}(object, formula, expset, omicset,
  set = "exposures", method = "ls", ..., baselevels, sva = "none",
  vfilter = NULL, verbose = FALSE, warnings = TRUE)
}
\arguments{
\item{object}{A \code{MultiDataSet} object containing at last one omic
data-sets like \code{ExpressionSet}, \code{MethylationSet}... and, at last,
one \code{ExposomeSet}.}

\item{formula}{formula to be evaluated by each exposure (or phenotype, see
\code{set} argument). It should not contain any exposures (or phenotype),
it will be added automatically when evaluated.}

\item{expset}{Name of the \code{ExposomeSet} in \code{object}.}

\item{omicset}{Name of the omic data-set in \code{object}.}

\item{set}{(default \code{"exposures"}) Can take value \code{"exposures"}
to test the association of the exposures in the \code{ExposomeSet} vs.
the features in the omic data-set. If takes \code{"phenotypes"} all
phenotypes in \code{ExposomeSet} are tested.}

\item{method}{(default \code{"lm"}) Check \code{limma} help pages.}

\item{...}{Arguments passed to \code{limma}'s \code{lmFit}.}

\item{baselevels}{(optional) If set, must be a labeled vector with the
default base level for categorical exposures.}

\item{sva}{(default \code{"none"}). This argument can take value
\code{"none"} to do not apply SVA. Value \code{"fast"} will run SVA
using \code{isva} and \code{SmartSVA}. Value \code{"slow"}
will run SVA using \code{sva}.}

\item{vfilter}{(default \code{NULL}). Only used when \code{sva = "slow"}.
Numeric number of probes used in \link{sva}. Recomended ~10\% of real probes.}

\item{verbose}{(default \code{FALSE}) If set to \code{TRUE}, a series of
messages descriving the process are shown.}

\item{warnings}{(default \code{TRUE}) If set to \code{TRUE}, a series of
warnings are shown when required user atention.}
}
\value{
An object of class \code{\link{ResultSet}}.
}
\description{
This function allows to perform an association study between gene
expression from microarray and the exposome. An \code{ExpresionSet} is
the object storing the gene expresion and an \code{ExposomeSet} the one
storing the exposome. Both of them needs to be encapsulated in a
\code{MultiDataSet}. The association study is perform through standard
\code{limma} pipeline. The function allows to perform multiple tests using
the argument \code{exposures}.
}
\examples{
library(MultiDataSet)
data(brge_prot, package = "brgedata")
data(brge_expo, package = "brgedata")
mds <- createMultiDataSet()
mds <- add_eset(mds, brge_prot, dataset.type = "proteines")
mds <- add_eset(mds, brge_expo, dataset.type = "exposures", GRanges = NA)

asr <- association(mds, formula = Asthma ~ Sex + Age,
  expset = "exposures", omicset = "proteines")
asr
}
