% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{hg19.GoNLsnps}
\alias{hg19.GoNLsnps}
\title{Dataframe with overlaps GoNL variants and 450K probes}
\format{A data frame with 207866 rows and 19 variables:
\describe{
  \item{CHROM}{chromosome, X and Y chromosomes are not available,
       since they are not included in this GoNL release}
  \item{probe}{probe ID}
  \item{type}{Infinium probedesign}
  \item{strand}{orientation of the probe}
  \item{probeType}{whether the probe measures a CpG-site (cg) or
       a non-CpG site (ch)}
  \item{location_c}{Location of the queried 'C' of the CpG dinucleotide. 
       Note that this is the location of the C that is actually measured.
       For probes that interrogate the reverse strand (plus-strand probes) 
       this is one base downstream of the C nucleotide on the forward strand}
  \item{location_g}{Location of the G nucleotide of the CpG dinucleotide. 
       Note that this is the location of the queried G. For probes that 
       interrogate the reverse strand (plus-strand probes) this is one base
       upstream of the G nucleotide on the forward strand}
  \item{ID}{SNP ID}
  \item{snpBeg}{Start coordinate of the variant. Identical to snpEnd for 
       SNPs.}
  \item{snpEnd}{End coordinate of the variant. Identical to snpBeg for SNPs}
  \item{AF}{Allele frequency of alternative allele}
  \item{REF}{Reference allele}
  \item{ALT}{Alternative allele}
  \item{FILTER}{Filter information from GoNL.}
  \item{MAF}{Minor allele frequency}
  \item{variantType}{SNP or INDEL}
  \item{distance_3end}{Distance between SNP and 3'end of the probe. For type
       I probes the 3'end of the probe coincides with the queried C 
       nucleotide. For type II probes the 3'end of the probe coincides with 
       the G nucleotide directly after the C nucleotide.}
  \item{distance_c}{Distance from queried C nucleotide. A distance of -1 
       indicates that the SNPs overlaps the SBE-position for type I probes.}
  \item{channel_switch}{Indicates whether a variant in the SBE-location of
       type I probes causes a color-channel-switch or overlap with an INDEL.
       For plus-strand probes C/T, C/A and C/G SNPs are expected to cause a 
       color-channel switch. For min-strand probes A/G, G/T and C/G SNPs are 
       expected to cause a color-channel switch.}
}}
\source{
\url{http://zwdzwd.github.io/InfiniumAnnotation}
        
    \url{https://molgenis26.target.rug.nl/downloads/gonl_public/variants/release5/}
}
\usage{
data(hg19.GoNLsnps)
}
\description{
Dataframe containing all SNPs and short INDELS from GoNLv5 that
overlap with 450K probes.  This release does not include X and Y
chromosomes, so only information for autosomal probes is
available. For each overlap there is an unique row. Consequently,
some probes are duplicated (probes that overlap with multiple
variants) and some variants are duplicated (some variants overlap
with more than one probe).
}
\examples{
    data(hg19.GoNLsnps)
    
    # Select variants that overlap with queried C nucleotide
    snps_c <- hg19.GoNLsnps[hg19.GoNLsnps$distance_c == 0, ] 
    
    # Select all INDELS
    indels <- hg19.GoNLsnps[hg19.GoNLsnps$variantType == "INDEL",] 
    
    # Select SNPs that cause a channel-switch
    channel_switch <- hg19.GoNLsnps[!is.na(hg19.GoNLsnps$channel_switch)
& hg19.GoNLsnps$channel_switch == "Yes",]

}
\keyword{datasets}
