% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/00_export_getAutoRIF.R
\name{getAutoRIF}
\alias{getAutoRIF}
\title{Get genes associated with search terms and AutoRIF annotations}
\usage{
getAutoRIF(term, rif = c("generif", "autorif")[1], filter = TRUE)
}
\arguments{
\item{term}{a character vector of terms want to search}

\item{rif}{either autorif or generif, see "https://maayanlab.cloud/geneshot/"}

\item{filter}{whether the result should be filtered. The least frequently 
mentioned genes (most like 1 or 2 times) will be removed.}
}
\value{
a \code{data.frame} of 4 columns: gene, n, perc, rank.
}
\description{
Get genes associated with search terms and AutoRIF annotations
}
\note{
https://amp.pharm.mssm.edu/geneshot/
}
\examples{
a <- getAutoRIF("mtor signaling")
}
\references{
Alexander Lachmann, Brian M Schilder, Megan L Wojciechowicz, 
  Denis Torre, Maxim V Kuleshov, Alexandra B Keenan, Avi Ma’ayan, Geneshot: 
  search engine for ranking genes from arbitrary text queries, Nucleic Acids 
  Research, Volume 47, Issue W1, 02 July 2019, Pages W571–W577, 
  https://doi.org/10.1093/nar/gkz393

Alexander Lachmann, Brian M Schilder, Megan L Wojciechowicz, 
  Denis Torre, Maxim V Kuleshov, Alexandra B Keenan, Avi Ma’ayan, 
  Geneshot: search engine for ranking genes from arbitrary text queries, 
  Nucleic Acids Research, Volume 47, Issue W1, 02 July 2019, Pages W571–W577, 
  https://doi.org/10.1093/nar/gkz393
}
