% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scores.R
\name{score_td}
\alias{score_td}
\title{Compute the number of large tandem duplication (TDplus).}
\usage{
score_td(segments)
}
\arguments{
\item{segments}{A \code{GRanges} object containing the segments, their copy
number and copy number types.}
}
\value{
A list of integer containing the TDplus score (\code{'TDplus'}) and
the small TD score (\code{'TD'}).
}
\description{
Compute the number of large tandem duplication (TDplus).
}
\details{
Procedure based on the paper from Popova et al., Cancer Res 2016
(PMID: 26787835). The TDplus score is defined as the number of regions larger
 than 1Mb but smaller or equal to 10Mb with a gain of one or two copies. This
 score was linked
 to CDK12-deficient tumors. They also identified as second category of tandem
  duplication whose size is smaller or equal than 1Mb and around 300Kb but
  could not link it to a phenotype. Note that due to its resolution the
  Oncoscan assay will most likely miss this second category. Nonetheless it
  is reported by the function.
}
\examples{
score_td(segs.chas_example)
}
