% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/templates.R, R/Scoring.R,
%   R/initialize_primers_tree.R, R/optimization_global.R
\name{Scoring}
\alias{Scoring}
\alias{score_conservation}
\alias{score_degen}
\alias{score_primers}
\title{Scoring Functions.}
\usage{
score_conservation(template.df, gap.char = "-", win.len = 30, by.group = TRUE)

score_degen(seq, gap.char = "-")

score_primers(
  primer.df,
  settings,
  active.constraints = names(constraints(settings)),
  alpha = 0.5
)
}
\arguments{
\item{template.df}{A \code{Templates} object providing the set of templates.}

\item{gap.char}{The gap character in the sequences.
The default is "-".}

\item{win.len}{The size of a window for evaluating conservation.
The default window size is set to 30.}

\item{by.group}{Whether the determination of binding regions 
should be stratified according to the groups defined in \code{template.df}.
The default is \code{TRUE}.}

\item{seq}{A list of vectors containing individual characters of a nucleotide sequence.}

\item{primer.df}{A \code{Primers} object containing the primers.}

\item{settings}{A \code{DesignSettings} object containing the
analysis settings.}

\item{active.constraints}{A character vector of constraint identifiers
that are considered for scoring the primers.}

\item{alpha}{A numeric that is used to determine the trade-off
between the impact of the maximal observed deviation and the total
deviation. At its default \code{alpha} is set to 0.5 such that
the maximal deviation and the total deviation have an equal weight
when computing the penalties.}
}
\value{
A list containing \code{Entropies} and \code{Alignments}.
\code{Entropies} is a data frame with conservation scores. 
Each column indicates a position in the alignment of template sequences
and each row gives the entropies of the sequences 
belonging to a specific group of template sequences.
\code{Alignments} is a list of \code{DNABin} objects, where each
object gives the alignment corresponding to one group of template sequences.

\code{score_degen} finds the number of unambiguous sequences
that are represented by \code{seq}.

\code{score_primers} returns a data frame containing
scores for individual primers.
}
\description{
\describe{
\item{\code{score_degen}}{Determines the degeneration score of a sequence.}
\item{\code{score_conservation}}{Determines the sequence conservation
scores of a set of templates using Shannon entropy.}
\item{\code{score_primers}}{Computes scores for a set of primers
based on the deviations of the primers from the constraints.}
}
}
\details{
\code{score_degen} computes the degeneration of an ambiguous sequence
by considering the number of unambiguous sequences that
are represented by the the ambiguous sequence.
Let a sequence \code{S} of length \code{n} be represented by a collection of sets such that
\deqn{S = {s_1, s_2, \ldots, s_n}}
where \eqn{s_i} indicates the set of unambiguous bases found
at position \eqn{i} of the primer. Then the degeneracy \eqn{D} of a primer
can be defined as 
\deqn{D = \prod_i{|s_i|}}
where \eqn{|s_i|} provides the number of disambiguated bases at position \eqn{i}.

\code{score_primers} determines the penalty of a primer in the following way.
Let \code{d} be a vector indicating the absolute deviations from 
individual constraints and let \code{p} be the scalar penalty that
is assigned to a primer. We define
\deqn{p = \alpha \cdot \max_i d_i + \sum_i (1 - \alpha) \cdot d_i}
such that for large values of \code{alpha} the maximal deviation 
dominates giving rise to a local penalty (reflecting the largest
absolute deviation) and for small \code{alpha} the total deviation
dominates giving rise to a global penalty 
(reflecting the sum of constraint deviations). 
When \code{alpha} is 1 only the most extreme absolute deviation is
considered and when \code{alpha} is 0 the sum of all absolute 
deviations is computed.
}
\note{
\code{score_conservation} requires the MAFFT software 
for multiple alignments (http://mafft.cbrc.jp/alignment/software/).
}
\examples{
\dontrun{
data(Ippolito)
entropy.data <- score_conservation(template.df, gap.char = "-", win.len = 18, by.group = TRUE)
}
# Compute degeneration for sequences with differing number of ambiguous bases
seq <- strsplit(c("ctggaattacggtacc", "taggaaccggrtaagc", "rtaaasrygtar"), split = "")
degen <- score_degen(seq)

# Score the primers
data(Ippolito)
primer.scores <- score_primers(primer.df, settings)
}
