% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filters.R
\name{cascaded.filter}
\alias{cascaded.filter}
\title{Filtering for the Optimization}
\usage{
cascaded.filter(
  primer.df,
  template.df,
  settings,
  mode.directionality = c("fw", "rev", "both"),
  required.cvg = 1,
  target.temps = NULL,
  updateProgress = NULL,
  results.loc = NULL
)
}
\arguments{
\item{primer.df}{Primer data frame.}

\item{template.df}{Template data frame.}

\item{settings}{Settings object.}

\item{mode.directionality}{Primer direction.}

\item{required.cvg}{Required ratio of covered templates.
If \code{required.cvg} is set to 0, the constraints are not relaxed.}

\item{target.temps}{Target melting temperature of the primers in Celsius.
This argument is only required if we try to match the melting temperatures of another primer set,
e.g. when first optimizing forward and then optimizing reverse primers.}

\item{updateProgress}{Progress callback function for shiny.}

\item{results.loc}{Directory where the filtering results should be stored.}
}
\value{
The filtered primer data frame with respect to \code{required.cvg}.
}
\description{
Filter primers according to constraints and relax constraints if necessary.
}
\details{
Constraints are relaxed if the \code{required.cvg} could not be reached with the input constraints.
}
\keyword{internal}
