% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/con_annealing_temperature.R
\name{compute.Ta}
\alias{compute.Ta}
\title{Annealing temperature}
\usage{
compute.Ta(
  primer.df,
  template.df,
  mode.directionality = c("fw", "rev", "both"),
  na_salt_conc,
  mg_salt_conc,
  k_salt_conc,
  tris_salt_conc,
  primer_conc
)
}
\arguments{
\item{primer.df}{Primer data frame.}

\item{template.df}{Template data frame}

\item{mode.directionality}{Primer directionality.}

\item{na_salt_conc}{Sodium ion concentration.}

\item{mg_salt_conc}{Magensium ion concentration.}

\item{k_salt_conc}{Potassium ion concentration.}

\item{tris_salt_conc}{Tris buffer concentration.}

\item{primer_conc}{Primer concentration.}
}
\value{
All annealing temperatures for given binding events.
}
\description{
Computes the annealing temperature using all binding events.
}
\references{
Rychlik, W. J. S. W., W. J. Spencer, and R. E. Rhoads. "Optimization of the annealing temperature for DNA amplification in vitro." Nucleic acids research 18.21 (1990): 6409-6412.
}
\keyword{internal}
