% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filters.R
\name{filter.primer.set.opti}
\alias{filter.primer.set.opti}
\title{Filtering of Primers}
\usage{
filter.primer.set.opti(
  primer.df,
  sample,
  template.df,
  settings,
  mode.directionality,
  required.cvg,
  results.loc,
  target.temps
)
}
\arguments{
\item{primer.df}{Primer data frame.}

\item{sample}{Name of the current template sample.}

\item{template.df}{Template data frame.}

\item{settings}{List with settings for the constraints to be used for filtering.}

\item{mode.directionality}{Primer direction.}

\item{required.cvg}{Required ratio of covered templates.
If \code{required.cvg} is set to 0, the constraints are not relaxed.}

\item{results.loc}{Path to a directory where the results should be written.}

\item{target.temps}{Target melting temperature of the primers in Celsius.
This argument is only required if we try to match the melting temperatures of another primer set,
e.g. when first optimizing forward and then optimizing reverse primers.}
}
\value{
The filtered primer data frame with respect to \code{required.cvg}.
}
\description{
Filters a primer set during the optimization procedure.
}
\keyword{internal}
