% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/templates.R
\name{read_templates_fasta}
\alias{read_templates_fasta}
\title{Input of Template Sequences.}
\usage{
read_templates_fasta(
  fasta.file,
  hdr.structure = NULL,
  delim = NULL,
  id.column = NULL,
  rm.keywords = NULL,
  remove.duplicates = FALSE,
  fw.region = c(1, 30),
  rev.region = c(1, 30),
  gap.character = "-",
  run = NULL
)
}
\arguments{
\item{fasta.file}{Path to a FASTA file containing the template sequences.}

\item{hdr.structure}{Names describing the information contained in the FASTA headers. In case that the headers of \code{fasta.file} contain
template group information, please include the keyword "GROUP" in
\code{hdr.structure}.}

\item{delim}{Delimiter for the information in the FASTA headers.}

\item{id.column}{Field in the header to be used as the identifier.}

\item{rm.keywords}{A vector of keywords that are used to remove templates whose headers contain any of the keywords.}

\item{remove.duplicates}{Whether duplicate sequence shall be removed.}

\item{fw.region}{The positional interval from the template 5' end specifying the 
binding sites for forward primers.}

\item{rev.region}{The positional interval from the template 3' end specifying
the binding sites for reverse primers.}

\item{gap.character}{The character in the input file representing gaps.
Gaps are automatically removed upon input.}

\item{run}{An identifier for the template sequences.}
}
\value{
An object of class \code{Templates}.
}
\description{
Read template sequences from a FASTA file.
}
\examples{
fasta.file <- system.file("extdata", "IMGT_data", "templates", 
              "Homo_sapiens_IGH_functional_exon.fasta", package = "openPrimeR")
hdr.structure <- c("ACCESSION", "GROUP", "SPECIES", "FUNCTION")
template.df <- read_templates(fasta.file, hdr.structure, "|", "GROUP")
}
\keyword{internal}
