% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trimmedKBarycenter.R
\name{trimmedKBarycenter}
\alias{trimmedKBarycenter}
\title{trimmedKBarycenter}
\usage{
trimmedKBarycenter(k, alpha0, type.ini = "rnd", reps.list)
}
\arguments{
\item{k}{Number k of elements in the k-barycenter.}

\item{alpha0}{Level of trimming.}

\item{type.ini}{of initialization in c('rnd', 'plus-plus'). 'rnd' makes the common random
initilaization while 'plus-plus' initializes in a similar fashion to k-means++.}

\item{reps.list}{List of multivariate normals for which the trimmed k-barycenter should be performed.}
}
\value{
A list with values:
\describe{
 \item{variacion_wasser}{A double giving the Waserstein variation.}
 \item{baricentro}{A list of k elements, each of which is a member of the k-barycenter.
  Each eement is a normal distribution characterized by a mean and a covariance.}
 \item{cluster}{The assignment of the original entries to each member of the k-barycenter.}
}
}
\description{
Calculates a 2-Wasserstein k-barycenter of a list of multivariate normal distributions.
}
\examples{
normals <- list(list(mean = c(1, 1), cov = diag(2, 2)), list(mean = c(1, 1),cov = diag(1, 2)),
 list(mean = c(3, 3), cov = diag(1, 2)))
trimmedKBarycenter(2, 0, 'rnd', normals)

}
