% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_bool_args.R
\name{check_bool_args}
\alias{check_bool_args}
\title{Check boolean args}
\usage{
check_bool_args(
  standardise_genes,
  drop_nonorths,
  as_sparse,
  as_DelayedArray,
  sort_rows
)
}
\arguments{
\item{standardise_genes}{If \code{TRUE} AND
\code{gene_output="columns"}, a new column "input_gene_standard"
will be added to \code{gene_df} containing standardised HGNC symbols
identified by \link[gprofiler2]{gorth}.}

\item{drop_nonorths}{Drop genes that don't have an ortholog
in the \code{output_species}.}

\item{as_sparse}{Convert \code{gene_df} to a sparse matrix.
Only works if \code{gene_df} is one of the following classes:\cr
\itemize{
 \item{\code{matrix}}
 \item{\code{Matrix}}
 \item{\code{data.frame}}
 \item{\code{data.table}}
 \item{\code{tibble}}
}
If \code{gene_df} is a sparse matrix to begin with,
it will be returned as a sparse matrix
 (so long as \code{gene_output=} \code{"rownames"} or \code{"colnames"}).}

\item{as_DelayedArray}{Convert aggregated matrix to
\link[DelayedArray]{DelayedArray}.}

\item{sort_rows}{Sort \code{gene_df} rows alphanumerically.}
}
\description{
Check that boolean args are indeed boolean
}
\keyword{internal}
