% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/machinelearning-functions-svm.R
\name{svmClassification}
\alias{svmClassification}
\alias{svmPrediction}
\title{svm classification}
\usage{
svmClassification(
  object,
  assessRes,
  scores = c("prediction", "all", "none"),
  cost,
  sigma,
  fcol = "markers",
  ...
)
}
\arguments{
\item{object}{An instance of class \code{"\linkS4class{MSnSet}"}.}

\item{assessRes}{An instance of class
\code{"\linkS4class{GenRegRes}"}, as generated by
\code{\link{svmOptimisation}}.}

\item{scores}{One of \code{"prediction"}, \code{"all"} or
\code{"none"} to report the score for the predicted class
only, for all classes or none.}

\item{cost}{If \code{assessRes} is missing, a \code{cost} must be
provided.}

\item{sigma}{If \code{assessRes} is missing, a \code{sigma} must
be provided.}

\item{fcol}{The feature meta-data containing marker definitions.
Default is \code{markers}.}

\item{...}{Additional parameters passed to \code{\link{svm}} from
package \code{e1071}.}
}
\value{
An instance of class \code{"\linkS4class{MSnSet}"} with
    \code{svm} and \code{svm.scores} feature variables storing the
    classification results and scores respectively.
}
\description{
Classification using the support vector machine algorithm.
}
\examples{
library(pRolocdata)
data(dunkley2006)
## reducing parameter search space and iterations 
params <- svmOptimisation(dunkley2006, cost = 2^seq(-2,2,2), sigma = 10^seq(-1, 1, 1),  times = 3)
params
plot(params)
f1Count(params)
levelPlot(params)
getParams(params)
res <- svmClassification(dunkley2006, params)
getPredictions(res, fcol = "svm")
getPredictions(res, fcol = "svm", t = 0.75)
plot2D(res, fcol = "svm")
}
\author{
Laurent Gatto
}
