% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_functions.R
\name{factorMap}
\alias{factorMap}
\title{Plot an MFA factor map for individuals or partial factor map based on 
padma analysis}
\usage{
factorMap(
  padma_obj,
  partial_id = NULL,
  dim_x = 1,
  dim_y = 2,
  plot_ellipse = TRUE,
  ggplot = TRUE,
  repel_labels = ifelse(ggplot == TRUE, TRUE, FALSE)
)
}
\arguments{
\item{padma_obj}{Output from running the \code{padma} function
(with \code{'full_results = TRUE'})}

\item{partial_id}{Index or sample name to be plotted for a 
partial factor map.}

\item{dim_x}{Dimension number of the MFA to be plotted on the x-axis.}

\item{dim_y}{Dimension number of the MFA to be plotted on the y-axis.}

\item{plot_ellipse}{If \code{TRUE}, superimpose a normal confidence ellipsis
on the factor map.}

\item{ggplot}{If \code{TRUE}, use \code{ggplot2} for plotting}

\item{repel_labels}{If \code{TRUE}, use \code{ggrepel} to repel sample 
labels from each other}
}
\value{
Plot, or factor map of class \code{ggplot} if \code{ggplot2 = TRUE}.
}
\description{
Produce an MFA factor map for individuals, or MFA partial factor map for
a given individual, for a pair of dimensions provided by the user.
}
\examples{

LUAD_subset <- padma::LUAD_subset
## Create MultiAssayExperiment object with LUAD data
omics_data <- 
  list(rnaseq = as.matrix(LUAD_subset$rnaseq),
       methyl = as.matrix(LUAD_subset$methyl),
       mirna = as.matrix(LUAD_subset$mirna),
       cna = as.matrix(LUAD_subset$cna))
pheno_data <- 
  data.frame(LUAD_subset$clinical, 
             row.names = LUAD_subset$clinical$bcr_patient_barcode)
mae <-
  suppressMessages(
    MultiAssayExperiment::MultiAssayExperiment(
      experiments = omics_data, colData = pheno_data))

## Run padma
run_padma <- 
  padma(mae, gene_map = padma::mirtarbase,
        pathway_name = "c2_cp_BIOCARTA_D4GDI_PATHWAY", verbose = FALSE)

summary(run_padma)

## padma plots
\dontrun{
factorMap(run_padma, dim_x = 1, dim_y = 2)
factorMap(run_padma, dim_x = 1, dim_y = 2,
           partial_id = "TCGA-78-7536")
omicsContrib(run_padma, max_dim = 10)
}
}
