% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/P_null.R
\name{P_null}
\alias{P_null}
\title{Build Null Distribution of Probability-Based Distance}
\usage{
P_null(expmat, net, n = 10000, sep = 5, method = c("difference", "mi"))
}
\arguments{
\item{expmat}{(matrix) Gene expression matrix.}

\item{net}{(data.frame) Network, with "reg" and "target" in column name.}

\item{n}{(numeric) Number of random pairs.}

\item{sep}{(numeric) Number of bins for calculating marginal/joint
probability.}

\item{method}{(character) Method for calculating probability-based distance,
either PXY-PXPY ("difference") or mutual information ("mi").}
}
\value{
(ecdf) ECDF of null distribution.
}
\description{
Build null model for evaluating the significance of interactions by
generating random regulator-target pairs.
}
\examples{
library(bcellViper)
data(bcellViper)
dset <- exprs(dset)
net <- do.call(rbind, lapply(1:10, function(i, regulon){
  data.frame(reg=rep(names(regulon)[i], 10),
             target=names(regulon[[i]][[1]])[1:10],
             direction=rep(1, 10),
             stringsAsFactors = FALSE)}, regulon=regulon))
P_null(dset, net, n=100, method="difference")

}
\author{
DING, HONGXU (hd2326@columbia.edu)
}
