% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createOmics_JoinPhenoAssay.R
\name{JoinPhenoAssay}
\alias{JoinPhenoAssay}
\title{Merge Phenotype and Assay Data by First Column (Sample ID)}
\usage{
JoinPhenoAssay(pheno_df, assay_df)
}
\arguments{
\item{pheno_df}{Phenotype data frame with the sample IDs in the first column}

\item{assay_df}{Assay data frame with the sample IDs in the first column}
}
\value{
A list of three elements:
  \itemize{
    \item{\code{assay} : }{A data frame with the rows from \code{assay_df}
      which are contained in \code{pheno_df}, ordered by their position in
      \code{pheno_df}.}
    \item{\code{response} : }{A data frame with the rows from
      \code{pheno_df} which are contained in \code{assay_df}.}
    \item{\code{sampleID} : }{A vector of the sample IDs shared by both data
      frames, ordered by their position in \code{pheno_df}.}
  }
}
\description{
Match the records from the phenotype data to the values in the
   assay data by sample ID. Return rows from each data frame with matches in
   both data frames. The sample ID must be the first column in both data
   frames.
}
\details{
Don't use this function. This is simply a wrapper around the
   \code{\link{merge}} function with extra checks for the class of the ID
   column. If you want to merge your two data frames by sample ID, you should
   use the \code{inner_join} function from the \code{dplyr} package instead.
   It's easier. See \url{https://dplyr.tidyverse.org/reference/join.html}.
}
\examples{
  # DO NOT CALL THIS FUNCTIONS DIRECTLY. USE CreateOmics() INSTEAD.

\dontrun{
 data("colonSurv_df")
 JoinPhenoAssay(
   pheno_df = colonSurv_df[, 1:3],
   assay_df = colonSurv_df[, -(2:3)]
 )
}

}
\keyword{internal}
