% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distro_expr.R
\name{distro_expr}
\alias{distro_expr}
\title{Plot distribution of expression values}
\usage{
distro_expr(rld, plot_type = "density")
}
\arguments{
\item{rld}{A \code{\link[DESeq2:DESeqTransform]{DESeq2::DESeqTransform()}} object.}

\item{plot_type}{Character, choose one of \code{boxplot}, \code{violin} or
\code{density}. Defaults to \code{density}}
}
\value{
A plot with the distribution of the expression values
}
\description{
Plot distribution of expression values
}
\examples{
dds <- makeExampleDESeqDataSet_multifac(betaSD_condition = 3, betaSD_tissue = 1)
rlt <- DESeq2::rlogTransformation(dds)
distro_expr(rlt)
}
