% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_annotation.R
\name{get_annotation}
\alias{get_annotation}
\title{Get an annotation data frame from biomaRt}
\usage{
get_annotation(dds, biomart_dataset, idtype)
}
\arguments{
\item{dds}{A \code{\link[DESeq2:DESeqDataSet]{DESeq2::DESeqDataSet()}} object}

\item{biomart_dataset}{A biomaRt dataset to use. To see the list, type
\code{mart = useMart('ensembl')}, followed by \code{listDatasets(mart)}.}

\item{idtype}{Character, the ID type of the genes as in the row names of
\code{dds}, to be used for the call to \code{\link[biomaRt:getBM]{biomaRt::getBM()}}}
}
\value{
A data frame for ready use in \code{pcaExplorer}, retrieved from biomaRt.
}
\description{
Get an annotation data frame from biomaRt
}
\examples{
library("airway")
data("airway", package = "airway")
airway
dds_airway <- DESeq2::DESeqDataSetFromMatrix(assay(airway),
                                             colData = colData(airway),
                                             design = ~dex+cell)
\dontrun{
get_annotation(dds_airway, "hsapiens_gene_ensembl", "ensembl_gene_id")
}
}
