\name{AffySNPPDInfoPkgSeed-class}
\Rdversion{1.1}
\docType{class}
\alias{AffySNPPDInfoPkgSeed-class}
%% \alias{chipName,AffySNPPDInfoPkgSeed-method}
%% \alias{getGeometry,AffySNPPDInfoPkgSeed-method}
%% \alias{makePdInfoPackage,AffySNPPDInfoPkgSeed-method}

\title{Class "AffySNPPDInfoPkgSeed"}
\description{
  This class represents Platform Design (PD) packages for Affymetrix
  mapping (SNP chip) arrays.
}
\section{Objects from the Class}{
  Objects can be created by calls of the form \code{new("AffySNPPDInfoPkgSeed", splineParamFile, crlmmInfoFile, referenceDistFile, ...)}.
}
\section{Slots}{
  \describe{
    \item{\code{splineParamFile}:}{Spline parameters file used to compute the
      predicted accuracy of the genotype calls.}
    \item{\code{crlmmInfoFile}:}{Data file containing regions data used
      by the \code{crlmm} function.}
    \item{\code{referenceDistFile}:}{Reference distribution file used in
    the normalization step by \code{snprma}.}
    \item{\code{cdfFile}:}{CDF file for the design.}
    \item{\code{csvAnnoFile}:}{Affymetrix CSV Annotation file.}
    \item{\code{csvSeqFile}:}{Affymetrix Probe Sequence file.}

    \item{\code{chipName}:}{Name of the chip or platform}
    \item{\code{manufacturer}:}{chip/platform manufacturer}
    \item{\code{url}:}{chip URL}
    \item{\code{genomebuild}:}{The genome build this platform is based
      upon.}
    \item{\code{organism}:}{ organism for chip. }
    \item{\code{species}:}{ species for chip. }  
    \item{\code{version}:}{A character vector giving the version
      number of the package.}
    \item{\code{license}:}{The license of the package}
    \item{\code{author}:}{Author of the package}
    \item{\code{email}:}{An email address to use in the Maintainer field}
    \item{\code{biocViews}:}{Character data for the biocViews field of
    the DESCRIPTION file}
  }
}
\section{Methods}{
  \describe{
    \item{chipName}{\code{signature(object = "AffySNPPDInfoPkgSeed")}: ... }
    \item{getGeometry}{\code{signature(object = "AffySNPPDInfoPkgSeed")}: ... }
    \item{makePdInfoPackage}{\code{signature(object = "AffySNPPDInfoPkgSeed")}: ... }
	 }
}


\note{
  *IMPORTANT* The user is strongly advised to download Affymetrix SNP
  packages from BioConductor.
  
  The files used for slots \code{splineParamFile}, \code{crlmmInfoFile},
  and \code{referenceDistFile} are generated by the Bioconductor project
  for each chip/platform and are hosted in our svn data repository at
  \url{https://hedgehog.fhcrc.org/bioc-data/trunk/annotation/parms_store}.
  When \code{makePdInfoPackage} is run, these files are simply copied to
  the \code{inst/extdata} directory of the generated package.
}

\examples{
showClass("AffySNPPDInfoPkgSeed")

cdfFile <- "Mapping250K_Nsp.cdf"
csvAnno <- "Mapping250K_Nsp_annot.csv"
csvSeq <- "Mapping250K_Nsp_probe_tab"

spline <- "pd.mapping250k.nsp.spline.params.rda"
refd <- "pd.mapping250k.nspRef.rda"
crlmmInf <- "pd.mapping250k.nspCrlmmInfo.rda"

pkg <- new("AffySNPPDInfoPkgSeed", 
           version="0.1.5",
           author="A. U. Thor", email="au@thor.net",
           biocViews="AnnotationData",
           genomebuild="NCBI Build 35, May 2004",
           cdfFile=cdfFile, csvAnnoFile=csvAnno, csvSeqFile=csvSeq,
           splineParamFile=spline, crlmmInfoFile=crlmmInf,
           referenceDistFile=refd)

showMethods(classes=class(pkg))
}
\keyword{classes}
