% Generated by roxygen2 (4.0.1): do not edit by hand
\name{PSMfilter}
\alias{PSMfilter}
\title{Filter the peptide indentification.}
\usage{
PSMfilter(PSMtab, pepFDR = 0.01, scorecolumn = "mvh", hitrank = 1,
    minpeplen = 6, decoyprefix = "rev_", ...)
}
\arguments{
\item{PSMtab}{a data frame contain peptide identification from a pepXML file}

\item{pepFDR}{filter the peptides based on this chosen FDR,
default is 0.01.}

\item{scorecolumn}{which column is chosen to calculate FDR}

\item{hitrank}{an integer indicates how many peptides to retain for a
spectrum. A spectrum can match to multiple peptides. Default is 1.}

\item{minpeplen}{an integer of minimum peptide length}

\item{decoyprefix}{a character indicates decoy sequence in the 'protein'
column. Usually is 'rev_' or 'DECOY_'.}

\item{...}{additional arguments}
}
\value{
a data frame object, contain PSMs (peptide spectrum match) passed
the filters.
}
\description{
The PSMfilter() function filter the peptide identification based on user
chosen paramter.
}
\details{
Filter the peptide identification based on FDR, hit rank, or peptide length.
}
\examples{
##MyriMatch example
pepxml <- system.file("extdata/pepxml", "Myrimatch.pepXML",
            package="pepXMLTab")
tttt <- pepXML2tab(pepxml)
passed <- PSMfilter(tttt, pepFDR=0.01, scorecolumn='mvh', hitrank=1,
        minpeplen=6, decoyprefix='rev_')
}
\author{
Xiaojing Wang
}

