% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pgxSegprocess.R
\name{pgxSegprocess}
\alias{pgxSegprocess}
\title{Extract, analyse and visualize "pgxseg" files}
\usage{
pgxSegprocess(
  file,
  group_id = "group_id",
  show_KM_plot = FALSE,
  return_metadata = FALSE,
  return_seg = FALSE,
  return_frequency = FALSE,
  assembly = "hg38",
  cnv_column_idx = 6,
  bin_size = 1e+06,
  overlap = 1000,
  soft_expansion = 0.1,
  ...
)
}
\arguments{
\item{file}{A string specifying the path and name of the "pgxseg" file where the data is to be read.}

\item{group_id}{A string specifying which id is used for grouping in KM plot or CNV frequency calculation. Default is "group_id".}

\item{show_KM_plot}{A logical value determining whether to return the Kaplan-Meier plot based on metadata. Default is FALSE.}

\item{return_metadata}{A logical value determining whether to return metadata. Default is FALSE.}

\item{return_seg}{A logical value determining whether to return segment data. Default is FALSE.}

\item{return_frequency}{A logical value determining whether to return CNV frequency data. The frequency calculation is based on segments in segment data and specified group id in metadata. Default is FALSE.}

\item{assembly}{A string specifying the genome assembly version to apply to CNV frequency calculation and plotting. Allowed options are "hg19" and "hg38". Default is "hg38".}

\item{cnv_column_idx}{Index of the column specifying the CNV state used for calculating CNV frequency.
The index must be at least 6, with the default set to 6. The CNV states should either contain "DUP" for duplications and "DEL" for deletions,
or level-specific CNV states represented using Experimental Factor Ontology (EFO) codes.}

\item{bin_size}{Size of genomic bins used in CNV frequency calculation to split the genome, in base pairs (bp). Default is 1,000,000.}

\item{overlap}{Numeric value defining the amount of overlap between bins and segments considered as bin-specific CNV, in base pairs (bp). Default is 1,000.}

\item{soft_expansion}{Fraction of \code{bin_size} to determine merge criteria.
During the generation of genomic bins, division starts at the centromere and expands towards the telomeres on both sides.
If the size of the last bin is smaller than \code{soft_expansion} * bin_size, it will be merged with the previous bin. Default is 0.1.}

\item{...}{Other parameters relevant to KM plot. These include \code{pval}, \code{pval.coord}, \code{pval.method}, \code{conf.int}, \code{linetype}, and \code{palette} (see ggsurvplot from survminer)}
}
\value{
Segments data, CNV frequency object, meta data or KM plots from local "pgxseg" files
}
\description{
This function extracts segment variants, CNV frequency, and metadata from local "pgxseg" files and supports survival data visualization.
}
\examples{
file_path <- system.file("extdata", "example.pgxseg",package = 'pgxRpi')
info <- pgxSegprocess(file=file_path,show_KM_plot = TRUE, return_seg = TRUE, return_metadata = TRUE)
}
