% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reading-writing.R
\name{reading}
\alias{reading}
\title{reading}
\usage{
reading(
  dir.c,
  files.ls = NULL,
  subsets.vc = NA,
  output.c = c("exp", "set")[1],
  report.c = c("none", "interactive", "myfile.txt")[2]
)
}
\arguments{
\item{dir.c}{character(1): directory containing the 3 tabular files (single
dataset), or containing several subdirectories with 3 tabular files
(multiple datasets)}

\item{files.ls}{list: if dir.c is set to NA, the full names of the
individual files can be provided; in case of a SummarizedExperiment, the
names of the list must be 'dataMatrix', 'sampleMetadata',
and 'variableMetadata' with the corresponding file full names;
in case of a MultiAssayExperiment, the list must consists of one such sublist
per dataset}

\item{subsets.vc}{character(): specifying a subset of the
subdirectories to be included in the MultiAssayExperiment (by default, all
subdirectories containing the 3 tables will be considered as datasets)}

\item{output.c}{character(1): Either 'exp' for SummarizedExperiment
(or MultiAssayExperiment), or 'set' for ExpressionSet (or MultiDataSet)
output formats (the latter are supported for convenience)}

\item{report.c}{character(1): File name for the printed results (call to
'sink()'); if NA (default), messages will be printed on the screen; if NULL,
no verbose will be generated}
}
\value{
\code{SummarizedExperiment} (one dataset) or
\code{MultiAssayExperiment} (multiple datasets) instance containing the
dataset(s)
}
\description{
Reading dataset(s) in the 3 tables 'dataMatrix' (or 'DM'), sampleMetadata'
(or 'SM') and variableMetadata' (or 'VM') tabular format. In case of a single
dataset (3 tables in the specified directory), a SummarizedExperiment
instance is returned. In case of a multiple dataset (several subfolders
containing 3 tables), a MultiAssayExperiment instance is created.
}
\examples{
data_dir.c <- system.file("extdata", package = "phenomis")
## 1) Single set
sacurine_dir.c <- file.path(data_dir.c, "sacurine")
sacurine.se <- reading(sacurine_dir.c)
# or
sacurine.se <- reading(NA,
                  files.ls = list(dataMatrix = file.path(sacurine_dir.c,
                                  "Galaxy1_dataMatrix.tabular"),
                                  sampleMetadata = file.path(sacurine_dir.c,
                                  "Galaxy2_sampleMetadata.tabular"),
                                  variableMetadata = file.path(sacurine_dir.c,
                                  "Galaxy3_variableMetadata.tabular")))
## 2) Multiple sets
prometis_dir.c <- file.path(data_dir.c, "prometis")
prometis.mae <- reading(prometis_dir.c)
metabo.mae <- reading(prometis_dir.c, subsets.vc = "metabo")
# or
prometis.mae <- reading(NA,
                       files.ls = list(metabo = list(dataMatrix = file.path(prometis_dir.c,
                                                           "metabo", "dataMatrix.tsv"),
                                                     sampleMetadata = file.path(prometis_dir.c,
                                                           "metabo", "sampleMetadata.tsv"),
                                                     variableMetadata = file.path(prometis_dir.c,
                                                           "metabo", "variableMetadata.tsv")),
                                       proteo = list(dataMatrix = file.path(prometis_dir.c,
                                                           "proteo", "dataMatrix.tsv"),
                                                     sampleMetadata = file.path(prometis_dir.c,
                                                           "proteo", "sampleMetadata.tsv"),
                                                     variableMetadata = file.path(prometis_dir.c,
                                                           "proteo", "variableMetadata.tsv"))))
}
