% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predictEthnicity.R
\name{predictEthnicity}
\alias{predictEthnicity}
\title{Predicts ethnicity using placental DNA methylation microarray data}
\usage{
predictEthnicity(betas, threshold = 0.75, force = FALSE)
}
\arguments{
\item{betas}{n x m dataframe of methylation values on the beta scale (0, 1),
where the variables are arranged in rows, and samples in columns. Should
contain all 1860 predictors and be normalized with NOOB and BMIQ.}

\item{threshold}{A probability threshold ranging from (0, 1) to call samples
'ambiguous'. Defaults to 0.75.}

\item{force}{run even if missing predictors. Default is \code{FALSE}.}
}
\value{
a \link[tibble:tibble-package]{tibble}
}
\description{
Uses 1860 CpGs to predict self-reported ethnicity on placental
microarray data.
}
\details{
Predicts self-reported ethnicity from 3 classes: Africans, Asians,
and Caucasians, using placental DNA methylation data measured on the Infinium
450k/EPIC methylation array. Will return membership probabilities that often
reflect genetic ancestry composition.

The input data should contain all 1860 predictors (cpgs) of the final GLMNET
model.

It's recommended to use the same normalization methods used on the training
data: NOOB and BMIQ.
}
\examples{
## To predict ethnicity on 450k/850k samples

# Load placenta DNAm data
data(plBetas)
predictEthnicity(plBetas)

}
